/*****************************************************
Header  : config DS18B20 for read temperature routines
Version : 1.0
Date    : 29/04/2011 1390/02/19
Author  : SEYD MOHSEN GHASEMIAN
Company : SMGH
Comments: SOURCE WEB: www.picpars.com
          E-mail:   picpars@gmail.com   
          
 EXP: getrc5();        
*****************************************************/

//Global variabl
    unsigned char add,com; //Address , Command 
    #define IRinput PIND.0
    #define IRled PORTD.1
// Clock value: 31.250 kHz
    
  void delay(unsigned char t){ 
    TIMSK=0x0;
    ASSR=0x00;
    TCCR2=0x05;
    TCNT2=t;    //255-74=181  4.752ms //255-27=228  4.752ms
    OCR2=0x00;
    while(!(TIFR & 0x40));
    TCCR2=0;
    TIFR|=0x40;
  }
  
   
  void getrc5(){
  unsigned char in,i;
  DDRD.0=0; //Input pin for reciver
  PORTD.0=1;
  DDRD.1=1; //Output pin for led reciver
  PORTD.1=0;
  
start1:
   add=com=0;
   IRled=0;
   if (IRinput==0) goto start2; //wait for frist low pulse
   goto start1;
  
start2:
    IRled=1;  
    delay(215);  //255-40=215  1.296ms       

      for(i=0; i<=6; i++){  //read frest 7bits Address
       in=IRinput;   
       add<<=1;
       add|=in;
       delay(201);  //255-54=201  1.728ms 
      } 
      
            add=add&0b00011111; //Cut off CHECK Bit 
      
      for(i=0; i<=5; i++){  //read next 6bits Command
       in=IRinput;  
       com<<=1;
       com|=in;
       delay(201);  //255-54=201  1.728ms  
      } 
            
      if(com > 63) goto start1; //Error in while Read DATA
      IRled=0;  
      delay_ms(30); //wait for Next signal
 }